<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Stok extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'produk_id',
        'jml_masuk',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function produk(): BelongsTo
    {
        return $this->belongsTo(Produk::class);
    }

    public function scopePencarian(Builder $query): void
    {
        $query->where('jml_masuk', 'like', '%' . request('cari') . '%')
            ->orwhereHas('produk', function ($query) {
                $query->where('nm_produk', 'like', '%' .  request('cari') . '%')->orWhere('kd_produk', 'like', '%' .  request('cari') . '%');
            });
    }
}
